from pprint import pprint

# načtení názvů států ze souboru s plochami
plochy = {} # slovník
with open('staty_plochy.log') as soubor:
    for řádka in soubor:
        stát, plocha = řádka.rstrip('\n').split(': ')
        plochy[stát] = plocha   # pod klíčem stát bude jeho plocha

# načtení názvů států ze souboru s počtem obyvatel
lidi = {}   # slovník
with open('staty_lidi.log') as soubor:
    for řádka in soubor:
        stát, počet_obyvatel = řádka.rstrip('\n').split(': ')
        lidi[stát] = počet_obyvatel # pod klíčem stát bude jeho počet obyvatel

# slovník hustoty zalidnění klíčovaný názvem státu
státy = {}

# počtů obyvatel je méně a všechny jejich státy jsou i v plochách
for stát, počet_obyvatel in lidi.items():
    státy[stát] = (
        plochy[stát],
        počet_obyvatel,
        int(počet_obyvatel) / float(plochy[stát])
    )

print(státy)
print(len(státy))   # 237
